'use strict';_={focWin:" The <b>focused window</b> is the window you are <br> currently working with, that's on top of the <br> others. <hr b>\n When you type something on your keyboard, <br> the text goes to this window. It can be any <br> window of any program.\n ",curWin:" The current Chrome window is the <c h=/focWin>focused window</c> <br>\n or, if no Chrome window is focused, the last Chrome <br> window that had focus.\n ",aotWin:" <b>Topmost windows</b> stay <u>always on top</u> of other <br> non-topmost windows even when not <c h=/focWin>focused</c>.\n ",
url:" A URL is the address of a web page or file on the internet. <br> It has the form: <br> <c blu>http://www.example.com/section/subsection/page.html</u>\n ",domPrt:" The <b>domain</b> part of a URL is the one marked in blue in this example: <hr b>\n <b>http://<u blu>www.subdomain.maindomain.com</u>/section/subsection/page.html</b>\n ",mDomPrt:' The <b>main domain</b> of a URL is the <c h=/domPrt>domain</c> minus all <br> subdomains at the left end (like <u>www</u> and others). <hr b>\n The technical term for this is <a b href="https://developer.mozilla.org/en-US/docs/Glossary/eTLD#:~:text=eTLD+1">eTLD+1</a>. <hr b=2>\n <b>Examples:</b> <hr b>\n <table brd align=center>\n <tr><th>Full domain <th>Main domain\n <tr><td blu blr>static.bbc.co.uk <td blu blr>bbc.co.uk\n <tr><td blu blr>en.wikipedia.org <td blu blr>wikipedia.org\n <tr><td blu blr>www.google.com   <td blu blr>google.com\n </table>\n ',
pthPrt:" The <b>path</b> part of a URL is the one marked in blue in this example: <hr b>\n <b>http://www.example.com<u blu>/section/subsection/page.html</u>?parameter=value</b> <hr b=2>\n The path always starts with a slash character, even if there isn't one <br> visible in the address bar.\n ",urlPrts:" A URL is composed of the following main parts: <hr b=1>\n <table>\n <tr  ><td prpl>Protocol <td> <td blu>Domain <td red>Path <td grn>Query <td orng>Fragment\n <tr b><td prpl u aRgt>http: <td>//<td blu u>www.example.com <td red u>/section/subsection/page.html <td grn u>?parameter=value <td orng u>#anchor\n </table>\n ",
ombar:" The <b>omnibox</b>, also called address bar, is the text <br> field at the top of a browser\n window that serves <br> the dual purpose of address bar and search bar.\n ",actTab:" The <b>active tab</b> in a Chrome window is the one <br> with a different color, whose content is visible. <hr b>\n There can only be one active tab per window.\n ",selTab:" <b>Selected tabs</b> have a slightly different color (do not <br> confuse them with the <c h=/actTab>active tab</c>). <hr b>\n You can select a group of tabs by holding down <key>Ctrl</key> <br> and then clicking on each tab. <hr b>\n Chrome allows you to perform some actions on a group <br> of selected tabs as a whole. For example, you can drag <br>\n them together, close them all at once, pin them, etc.\n ",
audTab:" Audible tabs are those currently playing audio or <br> video (unless the video has no sound). <br> They have a little speaker icon near the right edge.\n ",uldTab:" When the content of a tab is unloaded, that tab does not <br> consume system resources (CPU and memory) but it remains <br>\n open among the rest of your tabs. <hr b> You can unload tabs using the <b>Unload tabs</b> advanced action. <br>\n Also, tabs are sometimes unloaded automatically by Chrome <br> when it detects you are low on memory.\n ",
sysTr:" The <b>notification area</b> is the area next to <br> the clock in the taskbar (usually at the <br> bottom right corner of your screen). \n ",plcHld:` A placeholder is an expression between the <br> characters <b hl0>&lt; &gt;</b> that will be replaced with its <br>\n corresponding value when the action is performed. <hr b>\n Learn more about placeholders at <a href="${_Ce.scrtDoc}/placeholders">this page</a>.\n `,reqIncg:" <b>Caveat:</b> This requires <c h=/advOpts/incgAcc>incognito access</c>.\n ",
brwEvt:` AutoControl can react to a number of browser events such as <br> <c hl0>Tab opens</c>, <c hl0>Tab closes</c>, \n <c hl0>Tab audio starts</c>, and many others. <hr b>\n You can use these events as triggers in the same way keystrokes <br> and button presses are used to trigger actions. <br>\n For example, you can specify that whenever a Gmail tab is <br> opened, it must immediately be pinned;\n or when a Youtube tab <br> starts playing audio it must be <c h=/actTab>activated</c> automatically. <hr b=2>\n See <a href="${_Ce.triggers}">this page</a> for some examples of using events as triggers. <br> They are colored green.\n `,
favLst:` A <b>favorite list</b> is a temporal list of tabs that you can <br> manipulate while browsing.<br>\n You can add and remove tabs to these lists at any <br> moment and then perform actions on those tabs.\n <!--\n TODO: make the related website article\n <hr b=2> See <a href="${_Ce.favLists}">here</a> for examples of how to use this feature.\n -->\n `,mruOrd:" <u b>M</u>ost <u b>R</u>ecently <u b>U</u>sed order. This is the opposite <br>\n order in which the tabs were used. i.e. the tab that <br> you used last is the first one in the MRU order.\n ",
protPg:" <b>Protected pages</b> are inaccessible to Chrome extensions due to security <br> and other restrictions. These pages include: <hr b=2>\n <it></it>The New Tab Page: <c hl0 blu>chrome://newtab</c> <hr b=2>\n <it></it>Chrome's settings pages: <c hl0 blu>chrome://...</c> <hr b=2>\n <it></it>Extension pages: <c hl0 blu>chrome-extension://...</c> <hr b=2>\n <it></it>Chrome Web Store pages: <c hl0 blu>https://chrome.google.com/webstore/...</c> <hr b=2>\n <it></it>URLs starting with: <c hl0 blu>data: ...</c> or <c hl0 blu>view-source: ...</c> <hr b=2>\n \x3c!--it></it>Pages where Javascript is disabled <hr b=2 --\x3e\n \x3c!--it></it>Error pages (e.g 404 errors, network errors, etc.) <hr b=2 --\x3e\n \x3c!--it></it>Security warning pages <hr b=2 --\x3e\n <it></it><c ib>Local pages: <c hl0 blu>file:// ...</c> (can be unprotected by enabling <c h=/advOpts/fileAcc>local page access</c>)</c> <hr b=2>\n <it></it><c ib>Incognito tabs. (can be unprotected by enabling <c h=/advOpts/incgAcc>incognito access</c>)</c>\n \n \x3c!-- TODO: URLs that are blacklisted by the user in the extension's settings page are also \"protected\" --\x3e\n ",
nmdAct:` Named actions are those with a name <br> or description in its top bar. <hr b>See examples on <a href="${_Ce.actMenu}">this page</a>.\n `,fsPath:' An absolute path starts with a drive letter or a computer name: <hr b>\n <c hl mnsp>C:\\Users\\John\\...</c> <hr b>\n <c hl mnsp>\\\\RemotePC\\C\\Users\\...</c> <hr b=3>\n A relative path starts with a folder or file name: <hr b>\n <c hl mnsp>Pictures\\Birthday</c> <hr b>\n <c hl mnsp>Pictures\\Birthday\\Cake.jpg</c> <hr b=3>\n More details on <a href="https://www.computerhope.com/issues/ch001708.htm">this article</a>.\n ',
clpbrd:" The <b>clipboard</b> is the place in memory used for the <u>cut</u>, <br> <u>copy</u> and <u>paste</u> operations throughout\n the entire system. <br> When you cut or copy a portion of text on any program, <br> that text is stored in the clipboard. <hr b=2>\n Additionally, AutoControl supports 5 <c h=/actions/exClbrd>extra clipboards</c> that <br> can be used in some actions\n in order to avoid modifying <br> the system clipboard.\n ",hvrTabMore:' <hr b=2>\n If the action is triggered by a mouse gesture, then the hovered <br> tab will be obtained from the gesture\'s starting point instead of <br>\n the mouse\'s current point. See examples <a href="<{/URLS/hvrGest}>">here</a>. <hr b=2>\n Similarly, if the action is triggered from an <c h=/actions/menu>AutoControl menu</c>, <br> then the hovered tab will be obtained from the point\n the mouse <br> was when opening the menu and not from the point the mouse <br> is when clicking a menu item.\n See examples <a href="<{/URLS/hvrMnuAct}>">here</a>.\n ',
swtLst:" This is the list of all <c h=/switch>SWITCHES</c> you have created. The current state <br> of each switch is indicated with a red or green icon.\n Click on it to <br> toggle the switch to its opposite state. You can also rename each <br> switch by clicking on its name. <br>\n Switches are automatically removed from this list when they are <br> no longer used anywhere.\n ",switch:' A switch has two possible states (ON or OFF) and can be used as a condition in 2 places: <hr b=3>\n <style>\n [swtchPlaces] td {padding: 2px 10px}\n [swtchPlaces] td:first-child {border-right: 1px solid rgba(0,0,0,0.06)}\n [swtchPlaces] tr:first-child td {background: linear-gradient(rgba(0,0,0,0.05), transparent); border-top: 1px solid rgba(0, 0, 0, 0.13); padding: 5px 10px 6px;}\n </style>\n <table swtchPlaces>\n <tr><td><b>1. As a trigger condition:</b>\n <td><b>2. As a condition in the </b><act xsml>Continue chain if</act><b> action:</b>\n <tr><td valign=top><img src="/res/swtchTrigCond.png" width=284>\n <td><img src="/res/swtchActCond.png" width=300>\n </table>\n <hr b=3>\n After you create a switch, you can turn it ON and OFF as needed using 5 different ways. <c initDemo=setSwtchs>Click here to learn how.</c> \n ',
prmLst:" These are the permissions required by the entire content <br> of this settings file. <br>\n When you import one or more actions into your settings, <br> you'll be asked to grant one or more of these permissions <br> if they are not already granted.\n ",envEvts:{tbb:" It triggers when you click any of the 5 custom toolbar <br> buttons supported by AutoControl. <hr b>\n You can add these buttons to your toolbar by going to <br> <u>Options</u> > <u>Custom Toolbar Buttons</u>.",cbC:" It triggers whenever the <c h=/clpbrd>clipboard</c> content changes. <br> i.e. whenever a CUT or COPY operation is done. <{../cbEvtEx}>",
opn:" It triggers whenever a new tab is opened. <{../tabEvtEx}>",cls:" It triggers whenever a tab is closed. <hr b>\n <b>Caveat:</b> <br> This event happens AFTER the tab has already been closed. <br>\n Hence, actions you do in response to this event must not <br> depend on the existence of this tab.",act:" It triggers whenever a tab becomes <c h=/actTab>active</c>. <{../tabEvtEx}>",dAct:" It triggers whenever a tab goes from <c h=/actTab>active</c> to inactive. <{../tabEvtEx}>",foc:" It triggers whenever a tab gains the system focus. <br> i.e. when its containing window gains focus and the tab is <br>\n <c h=/actTab>the active one</c> in that window or when the tab is activated <br> in an already <c h=/focWin>focused window</c>. <{../tabEvtEx}>",
uFoc:" It triggers whenever a tab loses the system focus. <br> i.e. when its containing window loses focus and the tab is <br>\n <c h=/actTab>the active one</c> in that window or when the tab is deactivated <br> in an already <c h=/focWin>focused window</c>. <{../tabEvtEx}>",ldB:" It triggers whenever a tab begins loading a page. <{../tabEvtEx}>",ldE:" It triggers whenever a tab finishes loading a page. <{../tabEvtEx}>",uld:" It triggers whenever a tab's content is <c h=/uldTab>unloaded</c>. <{../tabEvtEx}>",
uChg:" It triggers whenever the <c h=/url>URL</c> of a tab changes. <{../tabEvtEx}> <hr b=3>\n Not all URL changes result in a new page being loaded, <br> such as when the <c h=/urlPrts>fragment part</c> of the URL changes, as <br>\n well as other cases. <br> If a URL change does result in a new page being loaded, <br> the <c hl0>Tab load begins</c> event will happen right after this one. \n ",audB:" It triggers whenever a tab becomes <c h=/audTab>audible</c>. <{../tabEvtEx}>",audE:" It triggers whenever a tab stops being <c h=/audTab>audible</c>. <{../tabEvtEx}>",
wOpn:" It triggers whenever a new Chrome window is opened. <{../winEvtEx}>",wCls:" It triggers whenever a Chrome window is closed. <hr b>\n <b>Caveat:</b> <br> This event happens AFTER the window has already been <br> closed.\n Hence, actions you do in response to this event <br> must not depend on the existence of this window.",wFoc:" It triggers whenever a Chrome window becomes <c h=/focWin>the focused one</c>. <{../winEvtEx}>",wUnf:" It triggers whenever a Chrome window loses the system focus. <{../winEvtEx}>",
min:" It triggers whenever a Chrome window is minimized. <{../winEvtEx}>",uMin:" It triggers whenever a Chrome window is unminimized. <{../winEvtEx}>",stu:' It triggers when AutoControl starts up and it\'s ready to execute actions. <br> This happens in the following cases: <hr b>\n <it></it><c ib>When the browser profile in which AutoControl is installed starts up, <br> i.e., when a browser window of that profile is opened for the first time.</c> <hr b>\n <it></it>When AutoControl is first installed in a browser profile. <hr b>\n <it></it>When AutoControl is reloaded or re-enabled in <a href="chrome://extensions">chrome://extensions</a>.\n '},
tse:{cur:" The <b>current tab</b> is the <c h=/actTab>active tab</c> in <br> the <c h=/curWin>current window</c>.",prv:" The tab you were using right before <br> the <c h=/tse/cur>current tab</c> in the current window.",prvAll:" The tab you were using right before the <c h=/tse/cur>current tab</c>, <br> even if that tab is in a different window.",nxt:" This is the opposite of <c h=/tse/prv>Previous tab</c>, i.e. it's the tab <br> you used after the <c h=/tse/cur>current tab</c> in the current window.",
nxtAll:" This is the opposite of <c h=/tse/prvAll>Previous tab (any win.)</c>, i.e. it's <br> the tab you used after the <c h=/tse/cur>current tab</c>, even if that tab <br> is in a different window.",act0:" The <c h=/actTab>active tab</c> is not necessarily the same <br>\n as the <c h=/tse/cur>current tab</c> when there's more than <br> one Chrome window open.",act:" All <c h=/actTab>active tabs</c>. If there's only one window open, <br> this is the same as the <c h=/tse/cur>current tab</c>.",opnr:" The tab that opened the <c h=/tse/cur>current tab</c> (if any).",
evt:" The tab or tabs pertaining to the <c h=/brwEvt>browser event</c> <br> that triggered the current action. <hr b>\n This is, of course, only applicable to actions that <br> were triggered by a <c h=/brwEvt>browser event</c>. <hr b=2>\n For window events, such as <c hl0>Window opens</c>, <br> <c hl0>Window focuses</c>, etc., the event tabs are those <br>\n contained in the window related to the event.\n ",nwst:" The tab that was opened most recently <br> in the <c h=/curWin>current window</c>.",
hvr:` <{/noSuprt}>\n The tab or tabs under the mouse cursor when it hovers over <br> any of the following elements: <hr b>\n <it></it> A tab in the <c h="/triggers/region/tabArea">tab strip</c>. <hr b>\n <it></it> A <c h=/triggers/region/mnuItm/types/tab>tab item</c> in an <c h=/actions/menu>AutoControl menu</c>. <hr b>\n <it></it> A <c h=/triggers/region/mnuItm/types/tbGrp>tab submenu item</c> in an <c h=/actions/menu>AutoControl menu</c>. <hr b>\n <it></it> Any other part of the browser window gives the <c h=/actTab>active tab</c>.\n <hr b=2>\n See <a href="${_Ce.mseHvrShrt}">this page</a> for useful examples.\n <{MORE}> <{../hvrTabMore}>\n `,
rgt:" The tab to the right of the <c h=/tse/cur>current tab</c>.",lft:" The tab to the left of the <c h=/tse/cur>current tab</c>.",hlt:" All <c h=/selTab>selected tabs</c> in the current window.",pin:" All pinned tabs in the <c h=/curWin>current window</c>.",aud:" All <c h=/audTab>audible tabs</c> on any window.",vsbl:" All tabs that are in non-minimized windows.",othr:" All tabs in the current window <br> except the <c h=/actTab>active tab</c>.",othrAll:" All tabs in all windows <br> except the <c h=/tse/cur>current tab</c>.",
curWmru:" All tabs in the current window ordered <br> from the <u b>M</u>ost <u b>R</u>ecently <u b>U</u>sed first.",allMru:" All tabs in all windows ordered from <br> the <u b>M</u>ost <u b>R</u>ecently <u b>U</u>sed tab first."},menuSpec:{cwMru:" All tabs in the <c h=/curWin>current window</c> in <c h=/mruOrd>MRU order</c>.",cwMruT:" All tabs in the <c h=/curWin>current window</c> in <c h=/mruOrd>MRU order</c> <br> with thumbnail previews.",awMru:" All tabs in all windows in <c h=/mruOrd>MRU order</c>.",
awMruT:" All tabs in all windows in <c h=/mruOrd>MRU order</c> <br> with thumbnail previews.",clsd:" All your closed tabs and windows.",clsdT:" All your closed tabs and windows <br> with thumbnail previews.",bkm:" Your entire bookmarks tree."},entName:" If you give this @{ent} a name, it'll be added <br> to the predefined list of @{ent}s so that you <br> can use it on other actions as well.",trans:()=>"file51.js",triggers:()=>"file15.js",actions:()=>"file53.js",tseEditor:()=>"file69.js",
menuEditor:()=>"file9.js",gest:{trig:" By default, a mouse gesture is performed while holding <br> down your <u>right mouse button</u>, but you can choose a <br>\n different button or keyboard key. <hr b>\n By choosing <b>Other</b>, you can customize the method for <br> beginning and ending a gesture separately.\n <{MORE}> <hr b=2>\n For example, rather than the usual method: <hr b>\n <b>1.</b> Hold a key/button down (gesture begins) <br>\n <b>2.</b> Perform the gesture <br>\n <b>3.</b> Release the key/button (gesture ends)\n <hr b=2>\n You could instead do something like: <hr b>\n <b>1.</b> Press <c hl0>Caps Lock</c> (gesture begins) <br>\n <b>2.</b> Perform the gesture <br>\n <b>3.</b> Press <c hl0>Caps Lock</c> again (gesture ends)\n <hr b=2>\n Or even use one key to begin the gesture and a <br> completely different key or button to end it. \n ",
tOut:" The maximum time you have for initiating a gesture from the <br> moment you press the mouse button. <br>\n If no gesture direction is detected during this time, the gesture <br> attempt will be canceled and the mouse button you are holding <br>\n down will be relayed to the hovered window.\n <{MORE}> <hr b=2> <b>Example:</b> <hr b>\n If you perform gestures with the right mouse button, and you <br> set this timeout to 1 second, then holding the right button for 1 <br>\n second without significant mouse movement will allow you to <br> use this button for dragging the element pointed by the mouse. <hr b>\n If you initiate a gesture before the 1 second timeout, dragging <br> will be prevented.\n ",
bgn:" You can specify any key, button or combination to begin <br> a mouse gesture. This is analogous to specifying a trigger <br>\n for an action, except the action here is to begin a gesture. <br> Multiple triggers for the same action are supported as <br> usual.\n ",end:" You can end a mouse gesture with the PRESS or RELEASE <br> of any key, button or combination. It can be the same as <br>\n for beginning a gesture or it can be a completely different <br> key or button.\n <{MORE}> <hr b=2>\n If you choose to end your gestures with a PRESS instead <br> of a RELEASE as is usual, then keep in mind that gestures <br>\n are affected by the <c h=/triggers/wildcard>combination wildcard</c> as any other key <br> or button.\n So you must set the wildcard of each gesture <br> to allow other keys/buttons to be pressed, otherwise the <br> gestures won't fire their action.\n ",
cnd:" You can specify here default conditions that will be applied to <br> all gestures that don't have a condition of the given types. <hr b=2>\n For example, if you specify here the following two conditions: <hr b>\n <c hl><c blk blr>Browser state:</c> &nbsp; <c blu blr><c fntSz=3>&#9673;</c>Focused</c> &nbsp; <c blu blr><c fntSz=3>&#9673;</c>Unfocused</c></c> <hr b>\n <c hl><c blk blr>Mouse over:</c> &nbsp; <c blu blr>Browser window</c></c> <hr b=3>\n then, the <c blr blk>Browser state</c> condition will be applied to all gestures <br> that don't have a <c blr blk>Browser state</c> condition. <br>\n Likewise for the <c blr blk>Mouse over</c> condition.\n ",
dir:" How many directions will be detected when <br> performing a gesture. <br>\n If you choose 4 directions, then any 8-direction <br> gestures you already have, will stop working.\n ",stp:" The minimum amount of mouse movement to <br> be detected as a change in direction. <br>\n Click on <b>Test gestures</b> to find the amount that <br> works best for you.\n ",dsp:" When you begin a gesture, a small display will appear <br> on the screen showing each direction of the gesture <br> your are performing.\n Once you end the gesture, the <br> display will disappear automatically.",
pos:" Where to show the gesture display. Top, center or <br> bottom of the screen or <c h=/focWin>focused window</c> or around <br> the mouse pointer.",siz:" The size of the gesture display.",col:" Color combination for the gesture display."},tbBtns:{inst:` Toolbar buttons are installed separately one by one. <br> You can specify a custom icon and title for each button. <hr b>\n To specify the action for a button, you must create an action <br> with the <c hl>Toolbar button clicked</c> <c h=/brwEvt>event</c> as a trigger.\n <hr b=2>\n See <a href="${_Ce.tbBtns}">this page</a> for examples of doing that.\n `},
iconPick:{sym:" The icon can be built from one or more characters <br> of any kind. Be it letters, numbers, symbols, emojis <br> or any possible\n character or sequence of characters <br> that you can enter in this text box. <hr b> Use the drop-down list to enter special symbols.\n ",img:" You can also use any image as an icon. <br> Either a local image in your computer, an <br> image from the web or a website's logo."},permMsgs:{newSttgs:" The new settings require the following permissions. <{common}>",
impSttgs:" The settings you are importing require the following permissions. <{common}>",feature:" This feature requires the following permissions. <{common}>",missing:" One or more of your actions need the following permissions which have not been granted yet. <{common}>",common:" <br> In the next dialog box you'll be asked to grant them."},permns:{bkm:["Bookmarks access","\n Allows AutoControl to read your bookmarks and create new ones. <hr b>\n This is needed by: <act inln xsml>Open bookmarks</act>, <act inln xsml>Bookmark tabs</act>, <act inln xsml>Open menu</act>.\n "],
ses:["Closed tabs access","\n Allows AutoControl to read and reopen your previously closed tabs. <hr b>\n This is needed by: <act inln xsml>Reopen closed tab</act>, <act inln xsml>Reopen tabs</act>, <act inln xsml>Open menu</act>.\n "],notf:["Display notifications","\n Allows AutoControl to display floating notifications <br> near the <c h=/sysTr>notification area</c>. <hr b>\n This is needed by: <act inln xsml>Save element URL</act>, <act inln xsml>Save URL</act>.\n "],dwld:["Manage downloads","\n Allows AutoControl to add new downloads to the <br> browser's download manager. <hr b>\n This is needed by: <act inln xsml>Save element URL</act>, <act inln xsml>Save URL</act>.\n "],
bg:["Background mode","\n Allows AutoControl to run even when no browser windows are open. <br>\n This is needed by the <c hl><c blk blr>Browser state:</c> &nbsp; <c blu blr><c fntSz=3>&#9673;</c>Closed</c></c> trigger condition.\n "],hst:["Site access","\n Allows AutoControl to communicate and interact with the webpages that <br> are currently loaded in your open tabs.\n This is needed by actions such as: <hr b=2>\n <act inln xsml>Open element URL</act>, <act inln xsml>Save element URL</act>, <act inln xsml>Copy Hovered URL</act>, <act inln xsml>Run script</act>\n "]},
settgs:{loc:' <img src="/res/settgsSync.png" align=right style="margin: -6px -5px -5px -5px; border-radius: 12px">\n <c ib>\n Each AutoControl installation running on <br> <c h=osUsr>this computer</c> can choose to synchronize its <br> settings with other installations that\n have also <br> chosen the same option in this select box. <hr b>\n No internet connection is required.\n <hr b=4>\n <c hl0 drk style="background: #529BE8">Across same browser</c> <br>\n Synchronize with other AutoControl <br> installations running on the same <br> <c h=brwBr>browser brand</c>.\n \n <hr b=5>\n <c hl0 drk style="background: #6666E2">Across all browsers</c> <br>\n Synchronize with other AutoControl <br> installations that have also chosen this <br> option, regardless of <c h=brwBr>browser brand</c>. \n </c>\n ',
rem:` <img src="/res/settgsSync.png" align=right style="margin: -5px -5px -5px 10px; border-radius: 12px">\n <c ib>\n Use the browser's sync feature to keep <br> AutoControl settings identical across devices. <hr b>\n You must first enable the sync feature <a href="chrome://settings/syncSetup">here</a>. <hr b=2>\n Remote sync has a delay of 5 to 20 seconds. <br> You <u>must not make changes</u> on other devices <br> until they are synchronized.\n Otherwise, the <br> most recent setting changes will be lost.<hr b=3>\n <b>Limitations:</b> <br>\n The browser's sync service allows a maximum <br> of ${_jj(_Ky.storage.sync.QUOTA_BYTES)}B of data.\n If your settings exceed this <br> limit, synchronization will not occur. <hr b=2>\n ${80>
_Ok?"":"\n Compressed synchronization doesn't work <br> before Chrome 80 (February 2020).\n If you need <br> to synchronize with those older browsers, don't <br> enable compression.\n "}\n `,brwBr:" The browser brand is determined from the browser's <br> name (Chrome, Edge, Brave, etc.). This name is used <br>\n to decide if two AutoControl installations are running <br> in the same browser.\n ",osUsr:" More accurately, installations running under <br> the same operating system's user account.\n ",
exp:' Save all your settings to a local file on your computer. <hr b><b>Tip:</b> <br> If you wish to save only a subset\n of your settings (i.e. specific <br> actions only) you have to select the desired actions in the <br> "Actions"\n section and then choose the option "Export to file".\n ',imp:" You can restore all your settings from a file (thereby <br> replacing your current settings) or you can add settings <br> from a file\n without replacing your current settings. <hr b> You'll be asked whether to add or replace once you <br> select the desired file.\n ",
opn:" View the contents of a settings file. <br> This allows you to view and select specific actions in a settings <br>\n file to then be imported into your AutoControl settings."},advOpts:{wldcrd:' The <c h=/triggers/wildcard>wildcard</c> to use on combinations that don\'t specify one. This will affect <br>\n all combinations of keys, buttons, wheels, gestures and <c h=/brwEvt>events</c>, except those <br>\n combinations that do specify a wildcard. <{MORE}> <hr b=2>\n If you often need to click on "<c blk blr>Emergency repair</c>" because some keys/buttons <br>\n get stuck down, you can use this option to specify that all your triggers use <br>\n a wildcard so that they work even if other keys/buttons are stuck in their <br> pressed state. <hr b>\n However, this is only a workaround for the problem, not a solution. Ideally, <br>\n you should find out what\'s causing keys/buttons to get stuck. <br>\n The most common cause are programs that inject malformed synthetic <br>\n keystrokes or button presses. If you suspect this might be your case, adjust <br>\n the "<b>Ignore synthetic input</b>" option below.\n ',
ignInj:" By default, AutoControl reacts to synthetic key/button presses injected by <br> other programs as if they were physical presses. \n This allows synthetic input <br> to have the same effect as physical input. <hr b>\n However, in some cases this may cause undesired effects if a program <br> injects malformed key-code sequences. <br>\n For example, if a program injects a key-press without a corresponding key-<br>release, AutoControl will think that the key is being held down\n permanently. <br>\n This will interfere with your shortcuts in the same way as if you were <br> physically holding an extra key down all the time. <hr b>\n If you are affected by this problem, you can choose to ignore synthetic <br> input coming from the keyboard, mouse or both.\n <{MORE}> <hr b=2>\n <b>Note:</b> <br>\n AutoControl always ignores synthetic input injected by itself via the <br> <act inln xsml>Synthesize Input</act> and\n <act inln xsml>Insert Text</act> actions, regardless of the option <br> you choose here.\n ",
repTm:' The maximum time allowed between repetitions of <br> a key/button/wheel when performing a trigger. <hr b=2>\n For example, in the following combination, the time <br> between the two presses of <key>A</key> must not exceed <br> this maximum. <hr b>\n <center><mid><key style="padding: 1px 4px">Control</key>+<key  style="padding: 1px 4px">A <c red sml>&times;2</c></key></mid></center>\n ',stpTm:" The maximum time allowed between consecutive <br> steps of a <c h=/triggers/mtStpTrg>multi-step trigger</c>.\n ",
fileAcc:` <b>Local pages</b> are those whose <c h=/url>URL</c> starts with <c hl mnsp>file://</c>, i.e., they are local <br> files on your computer or local network. <br>\n These pages are, by default, <c h=/protPg>protected pages</c>, which means some actions <br> won't work on them, such as: <hr b> \n <act inln xsml>Open element URL</act>, <act inln xsml>Save element URL</act>, <act inln xsml>Copy Hovered URL</act>, <act inln xsml>Run script</act>. <hr b=2>\n By enabling this access, those actions will be able to work on local pages too. <hr b=2>\n This access can only be enabled from the extension's <a href="${_Ce.fileAcc}">details page</a>.\n `,
incgAcc:` <b>Incognito access</b> allows AutoControl to work with your <a doc href="https://support.google.com/chrome/answer/95464">incognito</a> <br>\n tabs and windows. If this access is disabled, then all your incognito <br> tabs and windows will be invisible to AutoControl, which means <br>\n none of your actions will work on those windows. <hr b>\n This access can only be enabled from the extension's <a href="${_Ce.incogAcc}">details page</a>.\n `},noSuprt:` ${_hf._si.in("opera","vivaldi")?`<noSuprt>This feature is not supported in ${_hf._si.caplze()}</noSuprt>`:
""}`,sttgFilEdt:{new:" Create a new empty settings file.",opn:" Open an existing settings file.",sav:" Save changes to the settings file.",savAs:" Save everything to a new settings file.",disrd:" Discard unsaved changes.",imAll:" Import the entire content of this settings file (including <br> unsaved changes) into your AutoControl settings.",welcm:"\n <SFE_welcm>\n <style>\n SFE_welcm {padding: 3px 8px; display: block}\n SFE_welcm tit {display: block;  font-weight: bold;  font-size: 23px; text-align: center; color: hsl(213,60%,20%)}\n SFE_welcm n {color: #d50000; font: bold 16px arial}\n SFE_welcm demoWrap {width: 500px; height: 306px; display: block; margin: 0 auto; border-radius: 6px; overflow: hidden; box-shadow: 0 0 0 1px white, 1px 2px 6px hsl(204,10%,40%)}\n SFE_welcm [blk] {border-bottom: 1px dotted currentColor}\n </style>\n <tit>Welcome to the Settings File Editor</tit> <hr b=3>\n This editor lets you inspect, modify and import the contents of any AutoControl settings file. <hr b=2>\n There are 3 ways to import actions into your AutoControl settings: <hr b=2>\n <n>1</n>. You can import the entire content of the file by clicking the <c blk blr>Import all</c> button. <hr b=2>\n <n>2</n>. You can import individual actions by clicking the <c blk blr>Import</c> button or the <c blk blr>Import to</c> menu item. <hr b=2>\n <n>3</n>. You can import multiple actions by selecting them first and then clicking the <c blk blr>Import</c> or <c blk blr>Import to</c> menu items. <hr b=4>\n <demoWrap><demoPH demoName=SFEimport load play wrap noUI></demoPH></demoWrap>\n </SFE_welcm>\n "},
URLS:{getHvrElem:_df+"determining-hovered-element",hvrGest:"<{getHvrElem}>#mouse-gesture",hvrMnuAct:"<{getHvrElem}>#menu-action",condExec:_Ce.actions+"#condExec",tabGrps:"https://blog.google/products/chrome/manage-tabs-with-google-chrome/",newln:"https://wikipedia.org/wiki/Newline",prcntEnc:"https://wikipedia.org/wiki/Percent-encoding",cmdPrmt:"https://wikipedia.org/wiki/Command_Prompt",jsStr:"https://developer.mozilla.org/docs/Web/JavaScript/Data_structures#string_type",jsArr:"https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array",
jsObj:"https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object",envVar:"https://ss64.com/nt/syntax-variables.html"}};
